---
generated_at: 2026-01-22 14:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-Cohorts Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/cohorts_controller.rb` (行10-14, 16-18, 22-28)
- E-02: `app/services/cohorts_service.rb` (行4, 6-11, 26-46, 56-68, 82-94)
- E-03: `app/serializers/cohorts_serializer.rb`
- E-04: `app/serializers/cohorts_entity.rb`
- E-05: `app/serializers/cohort_entity.rb`
- E-06: 帳票一覧.csv (No.14の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示型のレポート | E-01 (コントローラ構造) | ○ |
| C-02 | /admin/cohortsでアクセス | E-01 (ルーティング) | ○ |
| C-03 | 過去12ヶ月分を表示 | E-02 (行4) | ○ |
| C-04 | MONTHS_INCLUDED = 12 | E-02 (行4) | ○ |
| C-05 | 1日間キャッシュ | E-01 (行23) | ○ |
| C-06 | CohortsServiceで計算 | E-01 (行24), E-02 | ○ |
| C-07 | CohortsSerializerで変換 | E-01 (行27), E-03 | ○ |
| C-08 | registration_monthを表示 | E-05 (行6-8) | ○ |
| C-09 | totalを表示 | E-05 (行10-12) | ○ |
| C-10 | inactiveを表示 | E-05 (行14-16) | ○ |
| C-11 | activity_monthsを表示 | E-05 (行18) | ○ |
| C-12 | 累積型のアクティビティ計算 | E-02 (行56-68) | ○ |
| C-13 | counts_by_monthでグループ化 | E-02 (行82-94) | ○ |
| C-14 | created_atで月単位TRUNCATE | E-02 (行97-99) | ○ |
| C-15 | last_activity_onで月単位TRUNCATE | E-02 (行97-99) | ○ |
| C-16 | percentageを計算 | E-02 (行66) | ○ |
| C-17 | number_with_delimiterで数値フォーマット | E-05 (行4, 11, 15) | ○ |
| C-18 | MMM YYYY形式で月表示 | E-05 (行7) | ○ |
| C-19 | track_eventでトラッキング | E-01 (行10-14) | ○ |
| C-20 | feature_category :devops_reports | E-01 (行6) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目に根拠あり、コードと整合

## 6) レビュアーチェックリスト（最小）
- [ ] /admin/cohortsにアクセスして画面表示を確認
- [ ] 12ヶ月分のコホートが表示されることを確認
- [ ] 各月のtotal、inactive、activity_monthsが表示されることを確認
- [ ] パーセンテージが正しく計算されることを確認
- [ ] キャッシュが1日間有効であることを確認
